// postSceneShadowing_flpoint.vsh

uniform mat4 vc0;	// worldViewProj
uniform mat4 vc4;
uniform mat4 vc8;
uniform vec4 vc12;
#ifdef TREE
uniform vec4 vc42;
uniform vec4 vc44;
uniform vec4 vc66;	// tree wind hack
#endif

void main()
{
#ifdef TREE
	// tree deformation
	vec4 r9;
    r9.x = gl_Vertex.x - vc66.y + vc42.w;
    r9.y = gl_Vertex.y;
    r9.z = gl_Vertex.z - vc66.z + vc44.w;
    r9.w = gl_Vertex.w;

    float r1x =  vc66.x * max(r9.x, r9.z);
	r1x *= 2.0;				// KLC -- Make tree swaying a little more obvious
    float r0y = sin(r1x);
	float r0x = cos(r1x);

	vec4 r5;
    r5.x = r0x;
    r5.y = 0.0;
    r5.z = -r0y;
    r5.w = vc66.y - vc42.w;

	vec4 r7;
    r7.x = r0y;
    r7.y = 0.0;
    r7.z = r0x;
    r7.w = vc66.z - vc44.w;

	vec4 r0;
    r0.x = dot(r9, r5);
    r0.y = gl_Vertex.y;
    r0.z = dot(r9, r7);
    r0.w = 1.0;

   #define POS r0
#else
   #define POS gl_Vertex
#endif

	// transform position
	gl_Position = POS * vc0;

	// Set to constant color
	gl_FrontColor = vec4(0.0, 0.0, 0.0, 0.0);
	
	// transform
	vec4 coord0 = POS * vc4;

	gl_TexCoord[0].s = coord0.x;
	gl_TexCoord[0].t = 1.0 - coord0.y;

#ifdef ALPHATEST
	gl_TexCoord[1].st = gl_MultiTexCoord0.st;
#endif

	// Depth in light space
	vec4 r1 = POS * vc8;
	gl_TexCoord[2].s = r1.z * vc12.x;
}

/*
vs.1.1

def c13, 0.0, 0.0, 0.0, 0.0

dcl_position0 v0

#ifdef ALPHATEST
dcl_texcoord0 v1
#endif

#ifdef TREE
   // Tell tree deformation snippet where the position and normal are.
   #define INPUT_POS v0
   
   // Deform.
   #include "tree_deform.vsh"
   
   // Outputs are in r0/r1
   #define POS r0
#else
   // Not tree-deformed so just use unmodified pos/normal.
   #define POS v0
#endif

// transform position
m4x4 oPos, POS, c0

// Set to constant color
mov oD0, c13

// Transform
m4x4 oT0, POS, c4

#ifdef ALPHATEST
mov oT1, v1
#endif

// Depth in light space
m4x4 r1, POS, c8

#ifdef ALPHATEST
mul oT2.x, r1.z, c12.x
#else
mul oT1.x, r1.z, c12.x
#endif
*/
